	clear all, close all 
	n = (0:511);
	x = 0.006*cos(2*pi*0.15*n) + 0.004*cos(2*pi*0.30*n); % Original signal
	X = fft(x,1024); 		% Spectrum of the original signal 
	wT = pi*n/512; 
	subplot(3,1,1);		PLOT_ABS_Z(wT, abs(X(1:512)),'\itX')
	axis([0 pi 0 2]);	text(0.5,0.8,'(a)')	
	M = 2; 					% Down-sampling factor 
	y = DOWN_SAMPLE(x,M); 	% Down-sampling  
	Y = fft(y,1024); 		% Spectrum of the down-sampled signal
	subplot(3,1,2); 	PLOT_ABS_Z(wT, abs(Y(1:512)),'\itY_D_S')	
 
	axis([0 pi 0 1]);	text(0.5,0.8,'(b)')
	yd = decimate(x,M); 	% Decimated signal 
	Yd = fft(yd,1024); 		% Spectrum of the decimated signal
	subplot(3,1,3); 		PLOT_ABS_Z(wT, abs(Yd(1:512)),'\itY_D_e_c')	
 
	axis([0 pi 0 1]);	xlabel('{\it\omegaT} [rad]'); text(0.5,0.8,'(c)')
	
	
